// -------------------------------------------------------------------- //
// wnd.h:
//
// class Wnd
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/sample/wnd/RCS/wnd.h,v 1.2 1994/04/25 14:30:33 kudou Exp $

#ifndef _wnd_h
#define _wnd_h

class VWin
{
 protected:
  // window handle
  HWND handle;
  
 public:
  VWin () { handle = 0; }
  HWND GetHandle () { return handle; }

 protected:
  void SetHandle (HWND h) { handle = h; }
};

class Wnd 
: public VWin
{
  static bool register_flag;

 protected:
  // register window class
  virtual bool RegisterFlag ();
  virtual void RegisterClass ();
  bool RegisteredP ();

 public:
  // constructor
  Wnd ();
  
  virtual ~Wnd ();
  virtual void OpenWindow ();
  virtual void Update ();

  operator void* () { return (!handle) ? 0 : this; }
  virtual long WindowProc (UINT msg, WPARAM wparam, LPARAM lparam);
  HDC GetDC ();
  void ReleaseDC (HDC dc);
};

CFUNC long CALLBACK WindowProc (HWND, UINT, WPARAM, LPARAM);

class Paint
{
  PAINTSTRUCT ps;
  HWND h;
  HDC dc;

 public:
  Paint (HWND h);
  ~Paint ();
  HDC GetDC () { return dc; }
};

#endif	/* _wnd_h */
