// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// dlg.h:
//
// class Dlg
// class ModalDlg
// class ModelessDlg
// -------------------------------------------------------------------- //
// $Header: /a/googol/d/1/proj/egypt/0/lw/src/RCS/dlg.h,v 1.6 1994/05/08 16:43:41 kudou Exp $

#ifndef _lw_dlg_h
#define _lw_dlg_h

#include "vwin.h"

CFUNC BOOL CALLBACK ModalDlgWindowProc (HWND, UINT, WPARAM, LPARAM);
CFUNC BOOL CALLBACK ModelessDlgWindowProc (HWND, UINT, WPARAM, LPARAM);

class Dlg
: public VWin
{
 protected:
  char* dlg_name;
  Dlg* next;
  VWin* parent;
 
 protected:
  void Add (Dlg*& dlglist);
  void Remove (Dlg*& dlglist);
  VWin* GetParent () { return parent; }
  HWND GetParentHandle ()
  { return (parent ? parent->GetHandle () : ::GetDesktopWindow ()); }

 public:
  Dlg (char* dlg_name, VWin* parent = 0);
  ~Dlg ();

  static Dlg* FindThis (Dlg*& dlglist, HWND handle);
  char* GetDlgName () { return dlg_name; }
  virtual BOOL WindowProc (UINT msg, WPARAM wparam, LPARAM lparam) = 0;
  Dlg* GetNext () { return next; }

  // utils
  void EndDialog (bool);
  HWND GetDlgItem (int);
  void SetDlgItemInt (int, WORD, BOOL);
  WORD GetDlgItemInt (int, BOOL FAR *, BOOL);
  void SetDlgItemText (int, LPSTR);
  int  GetDlgItemText (int, LPSTR, int);
  void CheckDlgButton (int, WORD);
  void CheckRadioButton (int, int, int);
  WORD DlgButtonCheckedP (int);
  LONG SendDlgItemMessage (int, WORD, WORD, LONG);
  void SetFocus (int id);
  bool EnableWindow (int id, bool a);
  bool WindowEnabledP (int id);

 protected:
  virtual BOOL WmInitDialog ();
  virtual BOOL WmCommand (WPARAM wparam);
  virtual BOOL WmClose ();

  friend BOOL CALLBACK ModalDlgWindowProc (HWND, UINT, WPARAM, LPARAM);
  friend BOOL CALLBACK ModelessDlgWindowProc (HWND, UINT, WPARAM, LPARAM);
};

class ModalDlg
: public Dlg
{
 public:
  ModalDlg (char* dlg_name, VWin* parent = 0);
  ~ModalDlg ();
  
  bool Go ();
  virtual BOOL WindowProc (UINT msg, WPARAM wparam, LPARAM lparam);
  long DefDlgProc (UINT msg, WPARAM wparam, LPARAM lparam);

 protected:
  virtual BOOL WmCommand (WPARAM wparam);
  virtual BOOL WmClose ();
};

class ModelessDlg
: public Dlg
{
 public:
  ModelessDlg (char* dlg_name, VWin* parent = 0);
  ~ModelessDlg ();

  bool Go ();
  virtual BOOL WindowProc (UINT msg, WPARAM wparam, LPARAM lparam);
  static bool CheckMessage (MSG* msg);
};

#endif /* _lw_dlg_h */
