// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// editwnd.h:
//
// class EditWnd
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/editwnd.h,v 1.11 1994/07/17 13:05:06 kudou Exp $

#ifndef _lw_editwnd_h
#define _lw_editwnd_h

class EditWnd
: public BaseWnd
{
  Wnd* parent;
  HMENU window_id;
  bool dirty;

  HANDLE h_lock_buf;
  char* lock_buf;
  uword lock_buf_size;
  
  bool file_name_set_p;
  char file_name[max_path_length + 1];
  
 public:
  EditWnd (Wnd* parent);
  ~EditWnd ();
  char* GetFileName () { return file_name; }
  HMENU GetWindowID () { return window_id; }
  void SetWindowID (HMENU id) { window_id = id; }

  virtual void OpenWindow ();
  virtual HWND GetParent ();
  virtual Wnd* GetParentWnd ();
  virtual DWORD GetCreateWindowStyle ();
  virtual void SetFocus ();
  virtual long WindowProc (UINT msg, WPARAM wParam, LPARAM lParam);
  virtual void UpdateCaption ();
  virtual void SetDefaultFileName ();

  bool GetDirty () { return dirty; }
  void SetDirty () { dirty = True; }
  void ClearDirty () { dirty = False; }

  // edit menu
  uword UndoEdit (bool menu_state);
  uword CutEdit (bool menu_state);
  uword CopyEdit (bool menu_state);
  uword PasteEdit (bool menu_state);
  uword DeleteEdit (bool menu_state);
  
  // file menu
  uword OpenFile (bool menu_state);
  uword SaveFile (bool menu_state);
  uword SaveAsFile (bool menu_state);
  uword CloseFile (bool menu_state);

  // create document
  char* LockBuffer ();
  void UnlockBuffer ();
  char* GetLockBuffer () { return lock_buf; }
  uword GetLockBufferSize () { return lock_buf_size; }
};

#endif /* _lw_editwnd_h */
