// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// filename.cpp:
//
// class FileNameDlg
// -------------------------------------------------------------------- //
// $Header: /a/googol/d/1/proj/egypt/0/lw/src/RCS/filename.cpp,v 1.4 1994/05/08 16:43:41 kudou Exp $

#include "lw.h"
#include "filename.h"
#include <string.h>

FileNameDlg::FileNameDlg (char* ini_file_name, VWin* parent)
{
  strncpy (file_name, ini_file_name, max_path_length);
  FileNameDlg::parent = parent;
}

bool
FileNameDlg::Go (bool save)
{
  // common dialog
  char start_dir[max_path_length];
  char filename_body[max_path_length];

  MSWin::GetExecPath (start_dir, sizeof (start_dir));
  memset (&ofn, 0, sizeof (OPENFILENAME));
  ofn.lStructSize = sizeof (OPENFILENAME);
  ofn.hwndOwner = parent ? parent->GetHandle () : ::GetDesktopWindow ();
  ofn.lpstrFilter = GetFilterStr ();
  ofn.nFilterIndex = 1;
  ofn.lpstrFile = file_name;
  ofn.nMaxFile = sizeof (file_name);
  ofn.lpstrFileTitle = filename_body;
  ofn.nMaxFileTitle = strlen (filename_body);
  ofn.lpstrInitialDir = start_dir;
  ofn.Flags = OFN_SHOWHELP | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
  if (save)
  {
    return ::GetSaveFileName (&ofn);
  }
  else
  {
    return ::GetOpenFileName (&ofn);
  }
}

LPSTR
FileNameDlg::GetFilterStr ()
{
  return "Text Files(*.txt)\0*.txt\0All(*.*)\0*.*\0";
}
