// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// mdi.cpp:
//
// class MdiFrameWnd
// class MdiClientWnd
// class MdiChildWnd
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/mdi.cpp,v 1.13 1994/07/17 13:05:06 kudou Exp $

#include "lw.h"

// -------------------------------------------------------------------- //
// class MdiFrameWnd
// -------------------------------------------------------------------- //
bool MdiFrameWnd::register_flag = False;

bool
MdiFrameWnd::RegisterFlag ()
{
  return register_flag;
}

void
MdiFrameWnd::SetRegisterFlag ()
{
  register_flag = True;
}

MdiFrameWnd::MdiFrameWnd ()
{
  mdi_client_wnd = 0;
}

MdiFrameWnd::~MdiFrameWnd ()
{
  delete mdi_client_wnd;
}

LPSTR
MdiFrameWnd::GetClassName ()
{
  return "MdiFrameWnd_WndV20";
}

LPSTR
MdiFrameWnd::GetCaptionStr ()
{
  return "MdiFrameWnd";
}

DWORD
MdiFrameWnd::GetCreateWindowStyle ()
{
  return (WS_OVERLAPPEDWINDOW | WS_MAXIMIZEBOX |
	  WS_MINIMIZEBOX | WS_CLIPCHILDREN);
}

void
MdiFrameWnd::OpenChildWindow ()
{
  mdi_client_wnd = new MdiClientWnd (this);
  mdi_client_wnd->OpenWindow ();
}

long
MdiFrameWnd::WindowProc (UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
   case WM_DESTROY:
    PostQuitMessage (0);
    break;
    
   case WM_SETFOCUS:
    SetFocus ();
    break;
    
   case WM_SIZE:
    {
      RECT rec;
      ::GetClientRect (GetHandle (), &rec);
      Resize (rec.left, rec.top, rec.right, rec.bottom);
    }
    break;
    
    case WM_PAINT:
    {
      Paint p (GetHandle ());
      Display (p.GetDC ());
    }
    break;

   case WM_INITMENUPOPUP:
    InitMenu ((HMENU)wparam);
    break;

   case WM_COMMAND:
    Menu (wparam, lparam);
    break;
    
   default:
    return ::DefFrameProc (GetHandle (), GetMdiClientHandle (),
			   msg, wparam, lparam);
  }
  return 0L;
}

void
MdiFrameWnd::Resize (WORD left, WORD top, WORD right, WORD bottom)
{
  mdi_client_wnd->MoveWindow (0, 0, right - left, bottom - top);
}

HWND
MdiFrameWnd::GetMdiClientHandle ()
{
  return mdi_client_wnd ? mdi_client_wnd->GetHandle () : 0;
}

HMENU
MdiFrameWnd::GetWindowMenu ()
{
  return 0;
}

// -------------------------------------------------------------------- //
// class MdiClientWnd
// -------------------------------------------------------------------- //
static MdiClientWnd* mdi_client_list;

void
MdiClientWnd::Add ()
{
  next = mdi_client_list;
  mdi_client_list = this;
}

void
MdiClientWnd::Remove ()
{
  MdiClientWnd* prev = 0;
  for (MdiClientWnd* wnd = mdi_client_list; wnd != 0; wnd = wnd->next)
  {
    if (wnd == this)
    {
      if (prev)
      {
	prev->next = next;
      }
      else
      {
	mdi_client_list = next;
      }
      break;
    }	
    prev = wnd;
  }
}

bool
MdiClientWnd::TranslateAccel (MSG* msg)
{
  for (MdiClientWnd* wnd = mdi_client_list;
       wnd != 0;
       wnd = wnd->next)
  {
    if ((wnd->GetHandle ()) &&
	(::TranslateMDISysAccel (wnd->GetHandle (), msg)))
    {
      return True;
    }
  }
  return False;
}

MdiClientWnd::MdiClientWnd (MdiFrameWnd* parent)
{
  MdiClientWnd::parent = parent;
  first_child_id = WndID_MdiChildWnd;
  Add ();
}

MdiClientWnd::~MdiClientWnd ()
{
  Remove ();
}

DWORD
MdiClientWnd::GetCreateWindowStyle ()
{
  return WS_CHILD | WS_CLIPCHILDREN | WS_VSCROLL | WS_HSCROLL;
}

void
MdiClientWnd::OpenWindow ()
{
  CLIENTCREATESTRUCT ccs;
  ccs.hWindowMenu = parent->GetWindowMenu ();
  ccs.idFirstChild = first_child_id;
  SetHandle (::CreateWindow ("MDICLIENT",
			     NULL,
			     GetCreateWindowStyle (),
			     0,
			     0,
			     0,
			     0,
			     GetParent (),
			     WndID_MdiClientWnd,
			     MSWin::GetInstance (),
			     (LPSTR)&ccs));
  Update ();
}

HWND
MdiClientWnd::GetParent ()
{
  return parent ? parent->GetHandle () : 0;
}

// -------------------------------------------------------------------- //
// class MdiChildWnd
// -------------------------------------------------------------------- //
bool MdiChildWnd::register_flag = False;

bool
MdiChildWnd::RegisterFlag ()
{
  return register_flag;
}

void
MdiChildWnd::SetRegisterFlag ()
{
  register_flag = True;
}

LPSTR
MdiChildWnd::GetClassName ()
{
  return "MdiChildWnd_WndV20";
}

WNDPROC
MdiChildWnd::GetWindowProc ()
{
  return ::MdiChildWindowProc;
}

LPSTR
MdiChildWnd::GetCaptionStr ()
{
  return "MdiChildWnd";
}

DWORD
MdiChildWnd::GetCreateWindowStyle ()
{
  return WS_HSCROLL | WS_VSCROLL;
}

MdiChildWnd::MdiChildWnd (MdiFrameWnd* mdi_frame_wnd)
{
  MdiChildWnd::mdi_frame_wnd = mdi_frame_wnd;
}

MdiChildWnd::~MdiChildWnd ()
{
}

void
MdiChildWnd::OpenWindow ()
{
  RegisterClass ();
  MDICREATESTRUCT mcs;
  mcs.szClass = GetClassName ();
  mcs.szTitle = GetCaptionStr ();
  mcs.hOwner = MSWin::GetInstance ();
  mcs.x = CW_USEDEFAULT;
  mcs.y = CW_USEDEFAULT;
  mcs.cx = CW_USEDEFAULT;
  mcs.cy = CW_USEDEFAULT;
  mcs.style = GetCreateWindowStyle ();
  mcs.lParam = (LPARAM) this;
  SetHandle ((WORD)::SendMessage (GetParent (),
				  WM_MDICREATE,
				  0,
				  (LONG)(LPMDICREATESTRUCT)&mcs));
  OpenChildWindow ();
  Update ();
}

void
MdiChildWnd::Update ()
{
  GetMdiClientWnd ()->SendMessage (WM_MDIACTIVATE, GetHandle (), 0); 
  ShowWindow (SW_SHOWNORMAL);
  UpdateWindow ();
  SetFocus ();
  RECT rec;
  GetWindowRect (&rec);
  SendMessage (WM_SIZE, SIZE_RESTORED, MAKELONG(rec.right - rec.left,
						rec.bottom - rec.top));
}

MdiClientWnd*
MdiChildWnd::GetMdiClientWnd ()
{
  return GetMdiFrameWnd ()->GetMdiClientWnd ();
}

HWND
MdiChildWnd::GetParent ()
{
  return mdi_frame_wnd->GetMdiClientHandle ();
}

long
MdiChildWnd::WindowProc (UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
   case WM_SETFOCUS:
    SetFocus ();
    break;
    
   case WM_SIZE:
    {
      RECT rec;
      ::GetClientRect (GetHandle (), &rec);
      Resize (rec.left, rec.top, rec.right, rec.bottom);
    }
    break;
    
    case WM_PAINT:
    {
      Paint p (GetHandle ());
      Display (p.GetDC ());
    }
    break;

   case WM_INITMENUPOPUP:
    InitMenu ((HMENU)wparam);
    return 0L;

   case WM_COMMAND:
    Menu (wparam, lparam);
    return 0L;
    
   default:
    break;
  }
  return ::DefMDIChildProc (GetHandle (), msg, wparam, lparam);
}

CFUNC long CALLBACK 
MdiChildWindowProc (HWND handle, UINT msg, WPARAM wparam, LPARAM lparam)
{
#if defined (__SMALL__) || defined (__MEDIUM__)
  Wnd* wd = (Wnd*)GetWindowWord (handle, 0);
#endif
#if defined (__LARGE__) || defined (__COMPACT__)
  Wnd* wd = (Wnd*)GetWindowLong (handle, 0);
#endif
  if (wd == 0)
  {
    if (msg == WM_CREATE)
    {
      LPCREATESTRUCT lpcs;
      lpcs = (LPCREATESTRUCT)lparam;
      LPMDICREATESTRUCT mdi = (LPMDICREATESTRUCT)lpcs->lpCreateParams;
      wd = (Wnd*)mdi->lParam;
#if defined (__SMALL__) || defined (__MEDIUM__)
      SetWindowWord (handle, 0, (WORD)wd);	// regist this to window
#endif
#if defined (__LARGE__) || defined (__COMPACT__)
      SetWindowLong (handle, 0, (LONG)wd);	// regist this to window
#endif
    }
    else
    {
      return ::DefMDIChildProc (handle, msg, wparam, lparam);
    }
  }
  else if (wd->GetHandle () == 0)
  {
    return ::DefMDIChildProc (handle, msg, wparam, lparam);
  }
  return wd->WindowProc (msg, wparam, lparam);
}
