// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// mswin.cpp:
//
// class MSWin
// -------------------------------------------------------------------- //
// $Header: /a/googol/d/1/proj/egypt/0/lw/src/RCS/mswin.cpp,v 1.10 1994/05/08 16:43:41 kudou Exp $

#include "lw.h"
#include <stdlib.h>

CFUNC int PASCAL 
WinMain (HANDLE instance, HANDLE prev_instance, LPSTR cmd_line, int show)
{
  MSWin main (instance, prev_instance, cmd_line, show);
  return Main ();
}

HANDLE MSWin::instance = 0;
HANDLE MSWin::prev_instance = 0;
LPSTR MSWin::cmd_line = 0;
int MSWin::cmd_show = 0;

MSWin::MSWin (HANDLE instance, HANDLE prev_instance,
	      LPSTR cmd_line, int cmd_show)
{
  MSWin::instance = instance;
  MSWin::prev_instance = prev_instance;
  MSWin::cmd_line = cmd_line;
  MSWin::cmd_show = cmd_show;
}

int 
MSWin::MessageLoop ()
{
  MSG msg;
  while (::GetMessage (&msg, NULL, 0, 0))
  {
    if (!Accel::TranslateAccel (&msg) &&
	!MdiClientWnd::TranslateAccel (&msg) &&
	!ModelessDlg::CheckMessage (&msg))
    {
      ::TranslateMessage (&msg);
      ::DispatchMessage (&msg);
    }
  }
  return msg.wParam;
}

bool
MSWin::OneMessage ()
{
  MSG msg;
  if (::GetMessage (&msg, NULL, 0, 0))
  {
    if (!Accel::TranslateAccel (&msg) &&
	!MdiClientWnd::TranslateAccel (&msg) &&
	!ModelessDlg::CheckMessage (&msg))
    {
      ::TranslateMessage (&msg);
      ::DispatchMessage (&msg);
    }
    return True;
  }
  return False;
}

void 
MSWin::GetExecPath (char* path, uword size)
{
  ::GetModuleFileName (GetInstance (), path, size);
  // remove file name
  char* p = path;
  char* end = 0;
  while (*p != '\0')
  {
    if (*p == '\\')
    {
      end = p;
    }
    p = ::AnsiNext (p);
  }
  if (end)
  {
    *end = '\0';
  }
}
