// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// profile.h:
//
// struct ProfileEntry
// class PrivateProfile
// class Profile
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/profile.h,v 1.1 1994/04/17 12:08:26 kudou Exp $

#ifndef _lw_profile_h
#define _lw_profile_h

struct ProfileEntry
{
  char* name;
  char* default_content;
  int id;
};

class InternalProfileEntry
: private ProfileEntry
{
 public:
  enum { entry_buf_size = 256 };
 private:
  char content[entry_buf_size];
  InternalProfileEntry* next;
  
 public:
  InternalProfileEntry (char* name, char* default_content, int id,
			InternalProfileEntry* next)
  {
    InternalProfileEntry::name = name;
    InternalProfileEntry::default_content = default_content;
    InternalProfileEntry::id = id;
    InternalProfileEntry::next = next;
    content[0] = '\0';
  }
  void Get (char* section, char* filename);
  void Write (char* section, char* filename);
  InternalProfileEntry* GetNext () { return next; }
  char* GetName () { return name; }
  int GetID () { return id; }
  char* GetContent () { return content; }
};

class PrivateProfile
{
  char* section;
  char* filename;
  InternalProfileEntry* entrys;

 public:
  PrivateProfile (char* section, char* filename,
		  ProfileEntry* init_entrys);
  ~PrivateProfile ();
  void Get ();
  void Write ();
  char* GetEntry (char* entry);
  char* GetEntry (int id);
  int GetEntryInt (char* entry);
  int GetEntryInt (int id);
  bool SetEntry (char* entry, char* content);
  bool SetEntry (int id, char* content);
  bool SetEntryInt (char* entry, int content);
  bool SetEntryInt (int id, int content);
 protected:
  InternalProfileEntry* GetInternalEntry (char* entry);
  InternalProfileEntry* GetInternalEntry (int id);
};

class Profile
: public PrivateProfile
{
 public:
  Profile (char* section, ProfileEntry* init_entrys);
  ~Profile ();
};

#endif /* _lw_profile_h */
