// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// rstr.cpp:
//
// class RStr
// manage resource string
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/rstr.cpp,v 1.1 1994/03/25 08:24:54 kudou Exp $

#include "lw.h"
#include <string.h>

RStr::RStr (UINT str_id)
{
  const int read_buf_size = 1024;
  static char read_buf[read_buf_size];

  buf = 0;
  size = MSWin::LoadString (str_id, read_buf, read_buf_size);
  if (size)
  {
    buf = new char [size + 1];
    strcpy (buf, read_buf);
  }
}

RStr::~RStr ()
{
  delete buf;
}
