// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// statwnd.h:
//
// class StatusWnd
// -------------------------------------------------------------------- //
// $Header: /a/googol/d/1/proj/egypt/0/lw/src/RCS/statwnd.h,v 1.4 1994/04/17 13:38:14 kudou Exp $

#ifndef _lw_statwnd_h
#define _lw_statwnd_h

class StatusWnd
: public BaseWnd
{
  static bool register_flag;

  int bar_height;
  char msg[256];
  Wnd* parent;

 public:
  StatusWnd (Wnd* parent);
  ~StatusWnd ();
  void SetBarHeight (int h) { bar_height = h; }
  int GetBarHeight () { return bar_height; }

 protected:
  virtual bool RegisterFlag ();
  virtual LPSTR GetClassName ();
  virtual UINT GetStyle ();
  virtual DWORD GetCreateWindowStyle ();
  virtual HWND GetParent ();
  virtual void Display (HDC hdc);

 public:
  void Printf (char* fmt, ...);
  void StrIdPrintf (UINT fmt_str_id, ...);
  void ClearMsg ();
};

#endif /* _lw_statwnd_h */
