// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// toolbar.cpp:
//
// class ToolBarWnd
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/toolbar.cpp,v 1.2 1994/04/24 05:25:42 kudou Exp $

#include "lw.h"
#include "toolbar.h"
#include <string.h>

bool ToolBarWnd::register_flag = False;

bool
ToolBarWnd::RegisterFlag ()
{
  return register_flag;
}

void
ToolBarWnd::SetRegisterFlag ()
{
  register_flag = True;
}

LPSTR
ToolBarWnd::GetClassName ()
{
  return "ToolBarWnd_WndV20";
}

DWORD
ToolBarWnd::GetCreateWindowStyle ()
{
  return WS_CHILD;
}

HWND
ToolBarWnd::GetParent ()
{
  return parent->GetHandle ();
}

long
ToolBarWnd::WindowProc (UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
   case WM_MOUSEMOVE:
    MouseMove (LOWORD (lparam), HIWORD (lparam));
    break;

   case WM_LBUTTONDOWN:
    MouseButtonDown (LOWORD (lparam), HIWORD (lparam));
    break;

   case WM_LBUTTONUP:
    MouseButtonUp (LOWORD (lparam), HIWORD (lparam));
    break;

   default:
    return BaseWnd::WindowProc (msg, wparam, lparam);
  }
  return 0L;
}

void
ToolBarWnd::Display (HDC hdc)
{
  int x_size = GetWindowXSize ();
  int y_size = GetWindowYSize ();
  RECT rec;
  rec.left = 0;
  rec.top = 0;
  rec.right = x_size;
  rec.bottom = y_size;
  ::FillRect (hdc, &rec, ::GetStockObject (LTGRAY_BRUSH));
  
  // display bitmap 
  char bitmapname[128];
  char sufix = ((button_size == SmallBtn) ? 'S' :
		((button_size == MiddleBtn) ? 'M' : 'L'));
  int m = GetEntryNum ();
  HDC hdc_mem = ::CreateCompatibleDC (hdc);
  for (ToolBarButtonEntry* e = entrys;
       e != 0;
       e = e->GetNext ())
  {
    m--;
    wsprintf (bitmapname, "%s%c", e->GetBitmapName (), sufix);
    HBITMAP hbmp = ::LoadBitmap (MSWin::GetInstance (), bitmapname);
    if (hbmp)
    {
      BITMAP bm;
      ::GetObject (hbmp, sizeof (BITMAP), &bm);
      HBITMAP hbmp_old = ::SelectObject (hdc_mem, hbmp);
      if ((m + 1) != pushed_button)
      {
	::BitBlt (hdc, m * button_size, 0, bm.bmWidth, bm.bmHeight, 
		  hdc_mem, 0, 0, SRCCOPY);
      }
      else
      {
	::BitBlt (hdc, m * button_size, 0, bm.bmWidth, bm.bmHeight, 
		  hdc_mem, 0, 0, NOTSRCCOPY);
      }
      ::SelectObject (hdc_mem, hbmp_old);
      ::DeleteObject (hbmp);
    }
  }
  ::DeleteDC (hdc_mem);
}

int
ToolBarWnd::GetEntryNum ()
{
  int n = 0;
  for (ToolBarButtonEntry* e = entrys;
       e != 0;
       e = e->GetNext ())
  {
    n++;
  }
  return n;
}

ToolBarWnd::ToolBarWnd (Wnd* parent)
{
  ToolBarWnd::parent = parent;
  entrys = 0;
  pushed_button = 0;
  int caption_height = ::GetSystemMetrics (SM_CYCAPTION);
  if (caption_height <= 16)
  {
    button_size = SmallBtn;
  }
  else if (caption_height <= 20)
  {
    button_size = MiddleBtn;
  }
  else
  {
    button_size = LargeBtn;
  }
}

ToolBarWnd::~ToolBarWnd ()
{
  ToolBarButtonEntry* e = entrys;
  while (e != 0)
  {
    ToolBarButtonEntry* next = e->GetNext ();
    delete e;
    e = next;
  }
  entrys = 0;
}

void
ToolBarWnd::AddButton (char* bitmap_name, int menu_id)
{
  entrys = new ToolBarButtonEntry (bitmap_name, menu_id, entrys);
}

ToolBarButtonEntry*
ToolBarWnd::GetNEntry (int n)
{
  int m = GetEntryNum () - n + 1;
  for (ToolBarButtonEntry* e = entrys;
       e != 0;
       e = e->GetNext ())
  {
    if (--m == 0)
    {
      return e;
    }
  }
  return 0;
}

int
ToolBarWnd::WhatButton (UINT x, UINT y)
{
  int n = (x / button_size) + 1;
  return ((n <= GetEntryNum ()) && (y < button_size)) ? n : 0;
}

void
ToolBarWnd::InvalidateButton (int n)
{
  if (n != 0)
  {
    RECT rec;
    rec.top = 0;
    rec.bottom = button_size;
    rec.left = (n - 1) * button_size;
    rec.right = n * button_size;
    ::InvalidateRect (GetHandle (), &rec, FALSE);
  }
}

int
ToolBarWnd::MouseMoveX (UINT x, UINT y)
{
  int n = WhatButton (x, y);
  if (n != 0)
  {
    ToolBarButtonEntry* e = GetNEntry (n);
    parent->PostMessage (WM_MENUSELECT, e->GetMenuId (), 0);
  }
  else
  {
    parent->PostMessage (WM_MENUSELECT, 0, 0);
  }
  return n;
}

void
ToolBarWnd::MouseMove (UINT x, UINT y)
{
  int n = MouseMoveX (x, y);
  if (pushed_button == 0)
  {
    if (n != 0)
    {
      ::SetCapture (GetHandle ());
    }
    else
    {
      ::ReleaseCapture ();
    }
  }
}

void
ToolBarWnd::MouseButtonDown (UINT x, UINT y)
{
  pushed_button = MouseMoveX (x, y);
  ::SetCapture (GetHandle ());
  InvalidateButton (pushed_button);
}

void
ToolBarWnd::MouseButtonUp (UINT x, UINT y)
{
  int n = MouseMoveX (x, y);
  if ((n != 0) && (n == pushed_button))
  {
    ToolBarButtonEntry* e = GetNEntry (n);
    parent->PostMessage (WM_COMMAND, e->GetMenuId (), 0);
  }
  n = pushed_button;
  pushed_button = 0;
  InvalidateButton (n);
  ::ReleaseCapture ();
}

int
ButtonMenuId::GetMenuId (ButtonMenuId* button_menu_id, char* bttn_name)
{
  for (ButtonMenuId* bmi = button_menu_id;
       bmi->bttn_name != 0;
       bmi++)
  {
    if (!strcmp (bttn_name, bmi->bttn_name))
    {
      return bmi->menu_id;
    }
  }
  return 0;
}

