// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// wnd.h:
//
// class Wnd
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/wnd.h,v 1.9 1994/05/05 16:19:56 kudou Exp $

#ifndef _lw_wnd_h
#define _lw_wnd_h

#include "vwin.h"

class Wnd 
: public VWin
{
  static bool register_flag;

 protected:
  // register window class
  virtual bool RegisterFlag ();
  virtual void RegisterClass ();
  bool RegisteredP ();

 public:
  // constructor
  Wnd ();
  
  virtual ~Wnd ();
  virtual void OpenWindow ();
  virtual void Update ();

  operator void* () { return (!handle) ? 0 : this; }
  virtual long WindowProc (UINT msg, WPARAM wparam, LPARAM lparam);
  HDC GetDC ();
  void ReleaseDC (HDC dc);

  // utils
  void GetWindowRect (RECT FAR* rec);
  int GetWindowXSize ();
  int GetWindowYSize ();
  virtual void SetFocus ();
  virtual void Resize (WORD left, WORD top, WORD right, WORD bottom);
  virtual void MoveWindow (WORD left, WORD top, WORD right, WORD bottom);
  void SetWindowText (char* caption);
  
  // messge box
  int MessageBox (LPCSTR text, LPCSTR title, UINT style)
  {
    return ::MessageBox (handle, text, title, style);
  }
  int MessageBox (UINT text_str_id, UINT title_str_id, UINT style);
  int MessageBox (LPCSTR text_str, UINT title_str_id, UINT style);
  int MessageBoxPrintf (LPCSTR text_str,
			UINT title_str_id, UINT style, ...);
  int MessageBoxPrintf (LPCSTR text_str,
			LPCSTR title_str, UINT style, ...);
  int MessageBoxPrintf (UINT text_fmtstr_id,
			UINT title_str_id, UINT style, ...);
  int MessageBoxPrintf (UINT text_fmtstr_id,
			LPCSTR title_str, UINT style, ...);
};

CFUNC long CALLBACK WindowProc (HWND, UINT, WPARAM, LPARAM);

#endif	/* _lw_wnd_h */
