// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// func.cc:
//
// class Func
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/func.cc,v 1.3 1994/05/02 16:05:02 kudou Exp $

#include "wool.h"
extern "C"
{
#include <assert.h>
}

#define Func_Ctor(x) \
Func::Func (WoolFunc ## x func, int type)\
{\
  f.func ## x = func;\
  func_type = type;\
  arg_num = x;\
}

Func_Ctor(0)
Func_Ctor(1)
Func_Ctor(2)
Func_Ctor(3)
Func_Ctor(4)

Func::~Func ()
{
}

size_t
Func::SizeOf ()
{
  return sizeof (Func);
}

WoolType
Func::TypeOf ()
{
  return WT_Func;
}

void
Func::Print (Wool& wool)
{
  wool.Printf ("<Func:");
  wool.Printf ("arg_num:%d>", arg_num);
}

Object*
Func::Func0 (Wool& wool)
{
  return (wool.*(f.func0)) ();
}

Object*
Func::Func1 (Wool& wool, Object* a1)
{
  return (wool.*(f.func1)) (a1);
}

Object*
Func::Func2 (Wool& wool, Object* a1, Object* a2)
{
  return (wool.*(f.func2)) (a1, a2);
}

Object*
Func::Func3 (Wool& wool, Object* a1, Object* a2, Object* a3)
{
  return (wool.*(f.func3)) (a1, a2, a3);
}

Object*
Func::Func4 (Wool& wool, Object* a1, Object* a2, Object* a3, Object* a4)
{
  return (wool.*(f.func4)) (a1, a2, a3, a4);
}

