// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// gclink.cc:
//
// class GCLink
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/gclink.cc,v 1.3 1994/05/02 16:05:02 kudou Exp $

#include "wool.h"

GCLink* GCLink::top = 0;

void
GCLink::SetGCMark ()
{
  for (GCLink* p = top; p != 0; p = p->GetNext ())
  {
    Object* o = p->GetPtr ();
    if (o && !o->GCMarkP ())
    {
      o->SetGCMark ();
    }
  }
}

GCLink*
GCLink::UnLink ()
{
  GCLink* prev = 0;
  for (GCLink* p = top; p != 0; p = p->GetNext ())
  {
    if (p == this)
    {
      assert (prev != 0);
      prev->next = next;
      return top;
    }
    prev = this;
  }
  return top;
}
