// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// object.cc:
//
// class Object
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/object.cc,v 1.5 1994/05/02 15:56:07 kudou Exp $

#include "wool.h"

int Object::object_num = 0;

Object::Object ()
{
  object_mark = True;
  gc_mark_p = False;
  object_num ++;
}

Object::~Object ()
{
  object_num --;
}

bool
Object::Equal (Object* x)
{
  return (this == x);
}

void*
Object::GetNextPtr ()
{
  return MemAline ((char*)this + SizeOf ());
}

void
Object::SetGCMark ()
{
  gc_mark_p = True;
}
