// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// pair.cc:
//
// class Pair
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/pair.cc,v 1.5 1994/05/02 15:56:07 kudou Exp $

#include "wool.h"

Pair::Pair (Object* car, Object* cdr)
{
  Pair::car = car;
  Pair::cdr = cdr;
}

Pair::~Pair ()
{
}

size_t
Pair::SizeOf ()
{
  return sizeof (Pair);
}

WoolType
Pair::TypeOf ()
{
  return WT_Pair;
}

void
Pair::Print (Wool& wool)
{
  wool.Printf ("Pair\n");
}

#if 0
// ̕@̓X^bNɏ邵x
void
Pair::SetGCMark ()
{
#ifdef STKMON
  static int level = 0;
  printf ("GCMark level: %d\n", level++);
#endif
  Object::SetGCMark ();
  if (car && !car->GCMarkP ())
  {
    car->SetGCMark ();
  }
  if (cdr && !cdr->GCMarkP ())
  {
    cdr->SetGCMark ();
  }
#ifdef STKMON
  level--;
#endif
}
#else
void
Pair::SetGCMark ()
{
#ifdef STKMON
  static int level = 0;
  printf ("GCMark level: %d\n", level++);
#endif
  Object::SetGCMark ();
  // car direction
  Object* o = Car ();
  while (o && !o->GCMarkP ())
  {
    if (o->TypeOf () != WT_Pair)
    {
      o->SetGCMark ();
      break;
    }
    o->Object::SetGCMark ();
    if (((Pair*)o)->Cdr ())
    {
      (((Pair*)o)->Cdr ())->SetGCMark ();
    }
    o = ((Pair*)o)->Car ();
  }
  // cdr direction
  o = Cdr ();
  while (o && !o->GCMarkP ())
  {
    if (o->TypeOf () != WT_Pair)
    {
      o->SetGCMark ();
      break;
    }
    o->Object::SetGCMark ();
    if (((Pair*)o)->Car ())
    {
      (((Pair*)o)->Car ())->SetGCMark ();
    }
    o = ((Pair*)o)->Cdr ();
  }
#ifdef STKMON
  level--;
#endif
}
#endif
