// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// str.cc:
//
// class Str
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/str.cc,v 1.4 1994/05/02 15:56:07 kudou Exp $

#include "wool.h"
extern "C"
{
#include <string.h>
}

Str::Str ()
{
  str = 0;
  alloc_size = 0;
}

Str::Str (char* s, size_t n)
{
  str = new char[n + 1];
  char* p = str;
  for (size_t i = 0; i < n; i++)
  {
    *p++ = *s++;
  }
  *p = '\0';
  alloc_size = n + 1;
}

Str::Str (char* s)
{
  size_t n = strlen (s);
  str = new char[n + 1];
  char* p = str;
  for (size_t i = 0; i < n; i++)
  {
    *p++ = *s++;
  }
  *p = '\0';
  alloc_size = n + 1;
}

Str::~Str ()
{
  delete str;
}

size_t
Str::SizeOf ()
{
  return sizeof (Str);
}

WoolType
Str::TypeOf ()
{
  return WT_Str;
}

void
Str::Print (Wool& wool)
{
  wool.Printf ("\"%s\"", str);
}

bool
Str::Equal (Object* x)
{
  if (x->TypeOf () == WT_Str)
  {
    return !strcmp (str, ((Str*)x)->str);
  }
  return False;
}
