// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// wool2.cc:
//
// class Wool
// initialize SUBER and FSUBER function
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/wool2.cc,v 1.13 1994/05/06 02:43:34 kudou Exp $

#include "wool.h"

#define Sent(x) \
struct Sent ## x \
{\
  char* name;\
  WoolFunc ## x func;\
  int type;\
}

#define FSent(x) \
struct FSent ## x \
{\
  char* name;\
  WoolFunc ## x func;\
  int type;\
}

void
Wool::InitSubr ()
{
  // ---------------------------------------------------------------------
  // SUBR function
  // ---------------------------------------------------------------------
  static Sent(0) subr0[] = 
  {
    { "readsexp"	, &Wool::ReadSexp	, Func::Normal },
    { "endrun"		, &Wool::EndRun		, Func::Normal },
    { "end"		, &Wool::EndRun		, Func::Normal },
    { "version"		, &Wool::Version	, Func::Normal },
    { "object-number"	, &Wool::GetObjectNumber, Func::Normal },
    { "gc"		, &Wool::RunGC		, Func::Normal },
    { "rand"		, &Wool::Rand		, Func::Normal },
#ifdef MATHFUNC
    { "math-error"      , &Wool:: MathError     , Func::Normal },
#endif /* MATHFUNC */
#ifdef MSWG
    { "clear-draw-window", &Wool::ClearDrawWindow, Func::Normal },
    { "get-draw-window-width", &Wool::GetDrawWindowWidth, Func::Normal },
    { "get-draw-window-height", &Wool::GetDrawWindowHeight, Func::Normal },
    { "get-draw-screen-width", &Wool::GetDrawScreenWidth, Func::Normal },
    { "get-draw-screen-height", &Wool::GetDrawScreenHeight, Func::Normal },
#endif /* MSWG */
    0
  };
  static Sent(1) subr1[] = 
  {
    { "atom"		, &Wool::Atom_		, Func::Normal },
    { "null"		, &Wool::Null		, Func::Normal },
    { "car"		, &Wool::Car		, Func::Normal },
    { "cdr"		, &Wool::Cdr		, Func::Normal },
    { "caar"		, &Wool::Caar		, Func::Normal },
    { "cadr"		, &Wool::Cadr		, Func::Normal },
    { "cdar"		, &Wool::Cdar		, Func::Normal },
    { "cddr"		, &Wool::Cddr		, Func::Normal },
    { "caaar"		, &Wool::Caaar		, Func::Normal },
    { "caadr"		, &Wool::Caadr		, Func::Normal },
    { "cadar"		, &Wool::Cadar		, Func::Normal },
    { "caddr"		, &Wool::Caddr		, Func::Normal },
    { "cdaar"		, &Wool::Cdaar		, Func::Normal },
    { "cdadr"		, &Wool::Cdadr		, Func::Normal },
    { "cddar"		, &Wool::Cddar		, Func::Normal },
    { "cdddr"		, &Wool::Cdddr		, Func::Normal },
    { "caaaar"		, &Wool::Caaaar		, Func::Normal },
    { "caaadr"		, &Wool::Caaadr		, Func::Normal },
    { "caadar"		, &Wool::Caadar		, Func::Normal },
    { "caaddr"		, &Wool::Caaddr		, Func::Normal },
    { "cadaar"		, &Wool::Cadaar		, Func::Normal },
    { "cadadr"		, &Wool::Cadadr		, Func::Normal },
    { "caddar"		, &Wool::Caddar		, Func::Normal },
    { "cadddr"		, &Wool::Cadddr		, Func::Normal },
    { "cdaaar"		, &Wool::Cdaaar		, Func::Normal },
    { "cdaadr"		, &Wool::Cdaadr		, Func::Normal },
    { "cdadar"		, &Wool::Cdadar		, Func::Normal },
    { "cdaddr"		, &Wool::Cdaddr		, Func::Normal },
    { "cddaar"		, &Wool::Cddaar		, Func::Normal },
    { "cddadr"		, &Wool::Cddadr		, Func::Normal },
    { "cdddar"		, &Wool::Cdddar		, Func::Normal },
    { "cddddr"		, &Wool::Cddddr		, Func::Normal },
    { "caaaaar"		, &Wool::Caaaaar	, Func::Normal },
    { "caaaadr"		, &Wool::Caaaadr	, Func::Normal },
    { "caaadar"		, &Wool::Caaadar	, Func::Normal },
    { "caaaddr"		, &Wool::Caaaddr	, Func::Normal },
    { "caadaar"		, &Wool::Caadaar	, Func::Normal },
    { "caadadr"		, &Wool::Caadadr	, Func::Normal },
    { "caaddar"		, &Wool::Caaddar	, Func::Normal },
    { "caadddr"		, &Wool::Caadddr	, Func::Normal },
    { "cadaaar"		, &Wool::Cadaaar	, Func::Normal },
    { "cadaadr"		, &Wool::Cadaadr	, Func::Normal },
    { "cadadar"		, &Wool::Cadadar	, Func::Normal },
    { "cadaddr"		, &Wool::Cadaddr	, Func::Normal },
    { "caddaar"		, &Wool::Caddaar	, Func::Normal },
    { "caddadr"		, &Wool::Caddadr	, Func::Normal },
    { "cadddar"		, &Wool::Cadddar	, Func::Normal },
    { "caddddr"		, &Wool::Caddddr	, Func::Normal },
    { "cdaaaar"		, &Wool::Cdaaaar	, Func::Normal },
    { "cdaaadr"		, &Wool::Cdaaadr	, Func::Normal },
    { "cdaadar"		, &Wool::Cdaadar	, Func::Normal },
    { "cdaaddr"		, &Wool::Cdaaddr	, Func::Normal },
    { "cdadaar"		, &Wool::Cdadaar	, Func::Normal },
    { "cdadadr"		, &Wool::Cdadadr	, Func::Normal },
    { "cdaddar"		, &Wool::Cdaddar	, Func::Normal },
    { "cdadddr"		, &Wool::Cdadddr	, Func::Normal },
    { "cddaaar"		, &Wool::Cddaaar	, Func::Normal },
    { "cddaadr"		, &Wool::Cddaadr	, Func::Normal },
    { "cddadar"		, &Wool::Cddadar	, Func::Normal },
    { "cddaddr"		, &Wool::Cddaddr	, Func::Normal },
    { "cdddaar"		, &Wool::Cdddaar	, Func::Normal },
    { "cdddadr"		, &Wool::Cdddadr	, Func::Normal },
    { "cddddar"		, &Wool::Cddddar	, Func::Normal },
    { "cdddddr"		, &Wool::Cdddddr	, Func::Normal },
    { "get"		, &Wool::Get		, Func::Normal },
    { "print"		, &Wool::PrintSexp	, Func::Normal },
    { "not"		, &Wool::Not		, Func::Normal },
    { "!"		, &Wool::Not		, Func::Normal },
    { "last"		, &Wool::Last		, Func::Normal },
    { "define"		, &Wool::Define		, Func::Normal },
    { "reverse"		, &Wool::Reverse	, Func::Normal },
    // numelical functions
    { "add1"		, &Wool::Add1		, Func::Normal },
    { "sub1"		, &Wool::Sub1		, Func::Normal },
    { "minus"		, &Wool::Minus		, Func::UnfixedArgNum },
    { "-"		, &Wool::Minus		, Func::UnfixedArgNum },
    { "plus"		, &Wool::Plus		, Func::UnfixedArgNum },
    { "+"		, &Wool::Plus		, Func::UnfixedArgNum },
    { "times"		, &Wool::Times		, Func::UnfixedArgNum },
    { "*"		, &Wool::Times		, Func::UnfixedArgNum },
    { "zerop"		, &Wool::ZeroP		, Func::Normal },
    { "minusp"		, &Wool::MinusP		, Func::Normal },
    { "length"		, &Wool::Length		, Func::Normal },
    { "numberp"		, &Wool::NumberP	, Func::Normal },
    { "floatp"		, &Wool::FloatP		, Func::Normal },
    { "fix"		, &Wool::Fix		, Func::Normal },
    { "max"		, &Wool::Max		, Func::UnfixedArgNum },
    { "min"		, &Wool::Min		, Func::UnfixedArgNum },
#ifdef MATHFUNC
    { "acos"		, &Wool::Acos		, Func::Normal },
    { "asin"		, &Wool::Asin		, Func::Normal },
    { "atan"		, &Wool::Atan		, Func::Normal },
    { "ceil"		, &Wool::Ceil		, Func::Normal },
    { "cos"		, &Wool::Cos		, Func::Normal },
    { "cosh"		, &Wool::Cosh		, Func::Normal },
    { "exp"		, &Wool::Exp		, Func::Normal },
    { "fabs"		, &Wool::Fabs		, Func::Normal },
    { "floor"		, &Wool::Floor		, Func::Normal },
    { "log"		, &Wool::Log		, Func::Normal },
    { "log10"		, &Wool::Log10		, Func::Normal },
    { "sin"		, &Wool::Sin		, Func::Normal },
    { "sinh"		, &Wool::Sinh		, Func::Normal },
    { "sqrt"		, &Wool::Sqrt		, Func::Normal },
    { "tan"		, &Wool::Tan		, Func::Normal },
    { "tanh"		, &Wool::Tanh		, Func::Normal },
#endif /* MATHFUNC */
    { "set-gc-message-mode", &Wool::SetGCMessageMode, Func::Normal },
#ifdef MSWG
    { "set-draw-pen-color", &Wool::SetDrawPenColor, Func::Normal },
    { "set-draw-fill-color", &Wool::SetDrawFillColor, Func::Normal },
    { "set-draw-back-color", &Wool::SetDrawBackColor, Func::Normal },
#endif /* MSWG */
    0
  };
  static Sent(2) subr2[] = 
  {
    { "cons"		, &Wool::Cons		, Func::Normal },
    { "eq"		, &Wool::Eq		, Func::Normal },
    { "rplaca"		, &Wool::Rplaca		, Func::Normal },
    { "rplacd"		, &Wool::Rplacd		, Func::Normal },
    { "eval"		, &Wool::Eval		, Func::Normal },
    { "assoc"		, &Wool::Assoc		, Func::Normal },
    { "evcon"		, &Wool::Evcon		, Func::Normal },
    { "evlis"		, &Wool::Evlis		, Func::Normal },
    { "cset"		, &Wool::CSet		, Func::Normal },
    { "equal"		, &Wool::Equal		, Func::Normal },
    { "=="		, &Wool::Equal		, Func::Normal },
    { "append"		, &Wool::Append		, Func::Normal },
    { "nconc"		, &Wool::Nconc		, Func::Normal },
    // mumelical functions
    { "difference"	, &Wool::Difference	, Func::Normal },
    { "quotient"	, &Wool::Quotient	, Func::Normal },
    { "/"		, &Wool::Quotient	, Func::Normal },
    { "remainder"	, &Wool::Remainder	, Func::Normal },
    { "%"		, &Wool::Remainder	, Func::Normal },
    { "greaterp"	, &Wool::GreaterP	, Func::Normal },
    { ">"		, &Wool::GreaterP	, Func::Normal },
    { "lessp"		, &Wool::LessP		, Func::Normal },
    { "<"		, &Wool::LessP		, Func::Normal },
    { "greateroreqp"	, &Wool::GreaterOrEqP	, Func::Normal },
    { ">="		, &Wool::GreaterOrEqP	, Func::Normal },
    { "=>"		, &Wool::GreaterOrEqP	, Func::Normal },
    { "lessoreqp"	, &Wool::LessOrEqP	, Func::Normal },
    { "<="		, &Wool::LessOrEqP	, Func::Normal },
    { "=<"		, &Wool::LessOrEqP	, Func::Normal },
    { "leftshift"	, &Wool::LeftShift	, Func::Normal },
    { "<<"		, &Wool::LeftShift	, Func::Normal },
    { "rightshift"	, &Wool::RightShift	, Func::Normal },
    { ">>"		, &Wool::RightShift	, Func::Normal },
#ifdef MATHFUNC
    { "pow"		, &Wool::Pow		, Func::Normal },
    { "atan2"		, &Wool::Atan2		, Func::Normal },
#endif /* MATHFUNC */
    { "printf"		, &Wool::Printf_	, Func::UnfixedArgNum },
#ifdef MSWG
    { "draw-pixel"	, &Wool::DrawPixel	, Func::Normal },
    { "dlg-message"	, &Wool::DlgMessage	, Func::Normal },
#endif /* MSWG */
    0
  };
  static Sent(3) subr3[] = 
  {
    { "apply"		, &Wool::Apply		, Func::Normal },
    { "pairlis"		, &Wool::Pairlis	, Func::Normal },
    { "set"		, &Wool::Set		, Func::CallWithEnv },
    { "subst"		, &Wool::Subst		, Func::Normal },
#ifdef MSWG
    { "rgb"		, &Wool::Rgb		, Func::Normal },
    { "draw-text"	, &Wool::DrawText	, Func::Normal },
    { "draw-transparent-text", &Wool::DrawTransparentText, Func::Normal },
    { "draw-arc-fill"	, &Wool::DrawArcFill	, Func::Normal },
    { "dlg-input"	, &Wool::DlgInput	, Func::Normal },
#endif /* MSWG */
    0
  };
  static Sent(4) subr4[] = 
  {
#ifdef MSWG
    { "draw-line"	, &Wool::DrawLine	, Func::Normal },
    { "draw-box"	, &Wool::DrawBox	, Func::Normal },
    { "draw-box-fill"	, &Wool::DrawBoxFill	, Func::Normal },
#endif /* MSWG */
    0
  };
  
  // ---------------------------------------------------------------------
  // FSUBR function
  // ---------------------------------------------------------------------
  static FSent(0) fsubr0[] = 
  {
    0
  };
  static FSent(1) fsubr1[] = 
  {
    { "quote"		, &Wool::Quote		, Func::Normal },
    { "defun"		, &Wool::Defun		, Func::UnfixedArgNum },
    0
  };
  static FSent(2) fsubr2[] = 
  {
    { "cond"		, &Wool::Evcon		, Func::UnfixedWithEnv },
    { "and"		, &Wool::And		, Func::UnfixedWithEnv },
    { "or"		, &Wool::Or		, Func::UnfixedWithEnv },
    { "list"		, &Wool::List		, Func::UnfixedWithEnv },
    { "let"		, &Wool::Let		, Func::UnfixedWithEnv },
    { "progn"		, &Wool::Progn		, Func::UnfixedWithEnv },
    { "prog1"		, &Wool::Prog1		, Func::UnfixedWithEnv },
    { "prog2"		, &Wool::Prog2		, Func::UnfixedWithEnv },
    { "while"		, &Wool::While		, Func::UnfixedWithEnv },
    { "if"		, &Wool::If		, Func::UnfixedWithEnv },
    0
  };
  static FSent(3) fsubr3[] = 
  {
    { "csetq"		, &Wool::CSetQ		, Func::CallWithEnv },
    { "setq"		, &Wool::SetQ		, Func::CallWithEnv },
    0
  };
  static FSent(4) fsubr4[] = 
  {
    0
  };

#define DefSubr(name, func, type) \
  SetBind (name, subr, new (this) Func (func, type));
  
#define DefSubrs(x) \
  {\
    Sent ## x* f = subr ## x;\
    while (f->name != 0)\
    {\
      DefSubr (f->name, f->func, f->type);\
      f ++;\
    }\
  }
  
  Object* subr = GetAtom ("subr");
  DefSubrs(0);
  DefSubrs(1);
  DefSubrs(2);
  DefSubrs(3);
  DefSubrs(4);
  
#define DefFSubr(name, func, type) \
  SetBind (name, fsubr, new (this) Func (func, type));
  
#define DefFSubrs(x) \
  {\
    FSent ## x* f = fsubr ## x;\
    while (f->name != 0)\
    {\
      DefFSubr (f->name, f->func, f->type);\
      f ++;\
    }\
  }
  
  Object* fsubr = GetAtom ("fsubr");
  DefFSubrs(0);
  DefFSubrs(1);
  DefFSubrs(2);
  DefFSubrs(3);
  DefFSubrs(4);
}

void
Wool::InitAtom ()
{
  atom_table.GetNil ();
  atom_table.GetT ();
  atom_table.GetQuote ();

  CSet (GetAtom ("t"), GetAtom ("t"));
  CSet (GetAtom ("nil"), 0);
}
