// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// wool3.cc:
//
// class Wool
// GC
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/wool3.cc,v 1.12 1994/05/02 18:55:44 kudou Exp $

#include "wool.h"

Object*
Wool::GetObjectNumber ()
{
  return new (this) Num (Object::GetObjectNumber ());
}

void*
operator new (size_t size, Wool* wool)
{
  return wool->GetMemory (size);
}

class ObjectIterator
{
  WoolHeap* wh;
  Object* o;
  char* end;
 public:
  ObjectIterator (WoolHeap* wh);
  Object* GetNext ();
};

ObjectIterator::ObjectIterator (WoolHeap* wh)
{
  ObjectIterator::wh = wh;
  o = 0; 
  end = (char*)(wh->GetEndPtr ());
}

Object*
ObjectIterator::GetNext ()
{
  char* p = ((o == 0) ?
	     (char*)(wh->GetMemTop ()) :
	     (char*)(o->GetNextPtr ()));
  while ((*p == 0) && p < (char*)end)
  {
    p++;
  }
  return o = ((p < end) ? (Object*)((void*)p) : 0);
}

void*
Wool::GetMemory (size_t size)
{
  if (size < sizeof (Free))
  {
    size = sizeof (Free);
  }
  for (WoolHeap* wh = heap_top; wh != 0; wh = wh->GetNext ())
  {
    Free* prev = 0;
    for (Free* f = wh->GetFreeTop (); f != 0; f = f->GetNext ())
    {
      void* mem = f->GetMemory (size);
      if (mem != 0)
      {
	if (mem == (void*)f)
	{
	  if (prev == 0)
	  {
	    wh->SetFreeTop (f->GetNext ());
	  }
	  else
	  {
	    prev->SetNext (f->GetNext ());
	  }
	  //
	  char* p = (char*)mem;
	  char* end = (char*)f->GetNextPtr ();
	  while (p < end)
	  {
	    *p++ = 0;
	  }
	}
	return mem;
      }
      prev = f;
    }
  }
#ifndef NOGC
  // Free ȂGC
  if (GC ())
  {
    void* p = GetMemory (size);
    if (p)
    {
      return p;
    }
  }
#endif
  // GC Ă Free Ȃ̂ŁAV WoolHeap 
  if (gc_message_mode)
  {
    Printf ("Alloc new Heap\n");
  }
  heap_top = new WoolHeap (heap_top);
  assert (heap_top != 0);
  
  return GetMemory (size);
}

bool
Wool::GC ()
{
  if (gc_message_mode)
  {
    Printf ("Garbage Correction...");
  }
  // ׂẴIuWFNg񂵂 GC }[NtONAB
  if (gc_message_mode)
  {
    Printf (".");
  }
  for (WoolHeap* wh = heap_top; wh != 0; wh = wh->GetNext ())
  {
    ObjectIterator oi(wh);
    Object* o;
    while ((o = oi.GetNext ()) != 0)
    {
      o->ClearGCMark ();
    }
  }

  // NameSpace, GCLink, Op Ȃǂǂ GC Ȃׂ̃}[N
  if (gc_message_mode)
  {
    Printf (".");
  }
  atom_table.SetGCMark ();
  if (gc_message_mode)
  {
    Printf (".");
  }
  GCLink::SetGCMark ();
  
  // Heap ǂ
  bool find_free_p = False;
  if (gc_message_mode)
  {
    Printf (".");
  }
  for (wh = heap_top; wh != 0; wh = wh->GetNext ())
  {
    ObjectIterator oi(wh);
    Object* o;
    while ((o = oi.GetNext ()) != 0)
    {
      if (!o->GCMarkP () && (o->TypeOf () != WT_Free))
      {
	// ̃IuWFNg͉\

	size_t size = o->SizeOf ();
	delete o;
	size_t extra_size = 0;
	char* p = (char*)((void*)o) + size;
	while ((void*)p < wh->GetEndPtr ())
	{
	  if (*p++ != 0)
	  {
	    break;
	  }
	  extra_size ++;
	}
	Free* f = new ((Free*)o) Free (size + extra_size, wh->GetFreeTop ());
	wh->SetFreeTop (f);
	find_free_p = True;
      }
    }
  }
  if (gc_message_mode)
  {
    Printf ("done.\n");
  }
  return find_free_p;
}

Object*
Wool::RunGC ()
{
  GC ();
  return 0;
}

Object*
Wool::SetGCMessageMode (Object* _mode)
{
  GCLink mode = _mode;
  if (NullP (mode))
  {
    gc_message_mode = None;
  }
  else if (TypeP_ (mode, WT_Num))
  {
    switch (((Num*)((Object*)mode))->GetNum ())
    {
     default:
     case 0:
      gc_message_mode = None;
      break;
     case 1:
      gc_message_mode = Show;
      break;
     case 2:
      gc_message_mode = Detail;
      break;
    }
  }
  else
  {
    Error ("SetGCMessageMode: bad argument.");
  }
  return 0;
}
