// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// xslist.cc:
//
// eXogenous(OI) Single List
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/xslist.cc,v 1.5 1994/07/14 09:04:11 kudou Exp $

#include "config.h"
#include "xslist.h"

// -------------------------------------------------------------------- //
// VOOIXg̃m[h\
// -------------------------------------------------------------------- //
class _XSListNode 
{
  // Xgvf
  void* item;
  
  // ̃m[h
  _XSListNode* next;
  
 public:
  // RXgN^
  _XSListNode (void* item = 0, _XSListNode* next = 0)
  {
    _XSListNode::item = item;
    _XSListNode::next = next;
  }
  
  // vf̎o
  void* GetItem () { return item; }
  
  // vf̐ݒ
  void SetItem (void* item) { _XSListNode::item = item; }
  
  // ̃m[h̎o
  _XSListNode* GetNext () { return next; }
  
  // ̃m[h̐ݒ
  void SetNext (_XSListNode* next) { _XSListNode::next = next; }
};

// -------------------------------------------------------------------- //
// class _XSList ̃\bh
// -------------------------------------------------------------------- //
_XSList::_XSList ()
{
  first = sentinel = new _XSListNode ();
}

_XSList::_XSList (_XList& l)
{
  first = sentinel = new _XSListNode ();
  if (l.GetXListID () == _XSListID)
  {
    // l ͓uOIXgv\
    _XSList& spl = (_XSList&)l;
    for (_XSListNode* node = spl.first; 
	 node != spl.sentinel; 
	 node = node->GetNext ())
    {
      sentinel->SetItem (node->GetItem ());
      _XSListNode* new_sentinel = new _XSListNode ();
      sentinel->SetNext (new_sentinel);
      sentinel = new_sentinel;
    }
  }
  else
  {
    // قȂuOIXgv\
    _XList::operator = (l);
  }
}

_XSList::~_XSList ()
{
  Clear ();
  delete sentinel;
}

void
_XSList::operator = (_XList& l)
{
  if (l.GetXListID () == _XSListID)
  {
    Clear ();
    _XSList& spl = (_XSList&)l;
    for (_XSListNode* node = spl.first;
	 node != spl.sentinel;
	 node = node->GetNext ())
    {
      sentinel->SetItem (node->GetItem ());
      _XSListNode* new_sentinel = new _XSListNode ();
      sentinel->SetNext (new_sentinel);
      sentinel = new_sentinel;
    }
  }
  else
  {
    _XList::operator = (l);
  }
}

_XListID
_XSList::GetXListID ()
{
  return _XSListID;
}

bool
_XSList::EmptyP ()
{
  return (first == sentinel) ? True : False;
}

unsigned int
_XSList::Number ()
{
  unsigned int num = 0;
  for (_XSListNode* node = first; 
       node != sentinel; 
       node = node->GetNext ())
  {
    num ++;
  }
  return num;
}

void*
_XSList::Access (unsigned int n)
{
  for (_XSListNode* node = first; 
       node != sentinel; 
       node = node->GetNext ())
  {
    if (--n == 0)
    {
      return node->GetItem ();
    }
  }
  return 0;
}

void*
_XSList::operator [] (unsigned int n)
{
  return Access (n + 1);
}

void*
_XSList::Prev (void* item)
{
  _XSListNode* prev = 0;
  sentinel->SetItem (item);
  for (_XSListNode* node = first; 
       node->GetItem () != item; 
       node = node->GetNext ())
  {
    prev = node;
  }
  if ((prev != 0) && (node != sentinel))
  {
    return prev->GetItem ();
  }
  return 0;
}

void*
_XSList::Next (void* item)
{
  sentinel->SetItem (item);
  for (_XSListNode* node = first; 
       node->GetItem () != item; 
       node = node->GetNext ())
  {
    ;
  }
  if ((node != sentinel) && (node->GetNext () != sentinel))
  {
    return node->GetNext ()->GetItem ();
  }
  return 0;
}

void*
_XSList::Head ()
{
  if (first == sentinel)
  {
    return 0;
  }
  return first->GetItem ();
}

void*
_XSList::Tail ()
{
  if (first == sentinel)
  {
    return 0;
  }
  for (_XSListNode* node = first; 
       node->GetNext () != sentinel; 
       node = node->GetNext ())
  {
    ;
  }
  return node->GetItem ();
}

void
_XSList::Push (void* item)
{
  first = new _XSListNode (item, first);
}

void*
_XSList::Pop ()
{
  if (first == sentinel)
  {
    return 0;
  }
  _XSListNode* node = first;
  first = first->GetNext ();
  void* item = node->GetItem ();
  delete node;
  return item;
}

void
_XSList::Inject (void* item)
{
  sentinel->SetItem (item);
  _XSListNode* new_sentinel = new _XSListNode ();
  sentinel->SetNext (new_sentinel);
  sentinel = new_sentinel;
}

void*
_XSList::Eject ()
{
  if (first == sentinel)
  {
    return 0;
  }
  for (_XSListNode* node = first; 
       node->GetNext () != sentinel; 
       node = node->GetNext ())
  {
    ;
  }
  delete sentinel;
  sentinel = node;
  return sentinel->GetItem ();
}

void
_XSList::InsertBefore (void* item, unsigned int pos)
{
  _XSListNode* prev = 0;
  for (_XSListNode* node = first; node != sentinel; node = node->GetNext ())
  {
    if (--pos == 0)
    {
      break;
    }
    prev = node;
  }
  if (node != sentinel)
  {
    if (prev)
    {
      prev->SetNext (new _XSListNode (item, node));
    }
    else
    {
      first = new _XSListNode (item, first);
    }
  }
}

void
_XSList::InsertBefore (void* item, void* pos)
{
  sentinel->SetItem (pos);
  _XSListNode* prev = 0;
  for (_XSListNode* node = first; 
       node->GetItem () != pos; 
       node = node->GetNext ())
  {
    prev = node;
  }
  if (node != sentinel)
  {
    if (prev)
    {
      prev->SetNext (new _XSListNode (item, node));
    }
    else
    {
      first = new _XSListNode (item, first);
    }
  }
}

void
_XSList::InsertAfter (void* item, unsigned int pos)
{
  for (_XSListNode* node = first; node != sentinel; node = node->GetNext ())
  {
    if (--pos == 0)
    {
      node->SetNext (new _XSListNode (item, node->GetNext ()));
      break;
    }
  }
}

void
_XSList::InsertAfter (void* item, void* pos)
{
  sentinel->SetItem (pos);
  for (_XSListNode* node = first; 
       node->GetItem () != pos;
       node = node->GetNext ())
  {
    ;
  }
  if (node != sentinel)
  {
    node->SetNext (new _XSListNode (item, node->GetNext ()));
  }
}

void
_XSList::Delete (void* pos)
{
  sentinel->SetItem (pos);
  for (_XSListNode* node = first; 
       node->GetItem () != pos;
       node = node->GetNext ())
  {
    ;
  }
  if (node != sentinel)
  {
    _XSListNode* next = node->GetNext ();
    if (next == sentinel)
    {
      sentinel = node;
    }
    else
    {
      node->SetItem (next->GetItem ());
      node->SetNext (next->GetNext ());
    }
    delete next;
  }
}

void
_XSList::Delete (unsigned int pos)
{
  for (_XSListNode* node = first;
       node != sentinel;
       node = node->GetNext ())
  {
    if (--pos == 0)
    {
      break;
    }
  }
  if (node != sentinel)
  {
    _XSListNode* next = node->GetNext ();
    if (next == sentinel)
    {
      sentinel = node;
    }
    else
    {
      node->SetItem (next->GetItem ());
      node->SetNext (next->GetNext ());
    }
    delete next;
  }
}

void
_XSList::Clear ()
{
  _XSListNode* node = first;
  while (node != sentinel)
  {
    _XSListNode* next = node->GetNext ();
    delete node;
    node = next;
  }
  first = sentinel;
}

void
_XSList::ExchangeItem (void* item, unsigned int pos)
{
  for (_XSListNode* node = first; node != sentinel; node = node->GetNext ())
  {
    if (--pos == 0)
    {
      node->SetItem (item);
      break;
    }
  }
}

void
_XSList::ExchangeItem (void* item, void* pos)
{
  sentinel->SetItem (pos);
  for (_XSListNode* node = first; 
       node->GetItem () != pos; 
       node = node->GetNext ())
  {
    ;
  }
  if (node != sentinel)
  {
    node->SetItem (item);
  }
}

void
_XSList::SwapItem (void* i1, void* i2)
{
  // find i1 node
  sentinel->SetItem (i1);
  for (_XSListNode* i1_node = first; 
       i1_node->GetItem () != i1; 
       i1_node = i1_node->GetNext ())
  {
    ;
  }
  // find i2 node
  sentinel->SetItem (i2);
  for (_XSListNode* i2_node = first;
       i2_node->GetItem () != i2;
       i2_node = i2_node->GetNext ())
  {
    ;
  }
  if ((i1_node != sentinel) &&
      (i2_node != sentinel))
  {
    void* swap_buf = i1_node->GetItem ();
    i1_node->SetItem (i2_node->GetItem ());
    i2_node->SetItem (swap_buf);
  }
}

void
_XSList::SwapItem (unsigned int n1, unsigned int n2)
{
  // find n1 node
  for (_XSListNode* n1_node = first;
       n1_node != sentinel;
       n1_node = n1_node->GetNext ())
  {
    if (--n1 == 0)
    {
      break;
    }
  }
  // find n2 node
  for (_XSListNode* n2_node = first;
       n2_node != sentinel;
       n2_node = n2_node->GetNext ())
  {
    if (--n2 == 0)
    {
      break;
    }
  }
  if ((n1_node != sentinel) &&
      (n2_node != sentinel))
  {
    void* swap_buf = n1_node->GetItem ();
    n1_node->SetItem (n2_node->GetItem ());
    n2_node->SetItem (swap_buf);
  }
}

#ifndef NODEBUG
extern "C"
{
#include <stdio.h>
}

void
_XSList::Show ()
{
  printf ("_XSListNode* first    :%p\n", first);
  printf ("_XSListNode* sentinel :%p\n", sentinel);
  printf ("node list\n");
  for (_XSListNode* node = first; 
       node != sentinel; 
       node = node->GetNext ())
  {
    printf ("node: %p [item:%p] next:%p\n", 
	   node, node->GetItem (), node->GetNext ());
  }
}

#endif /* NODEBUG */
// -------------------------------------------------------------------- //
// class _XSListIterator ̃\bh
// -------------------------------------------------------------------- //
_XSListIterator::_XSListIterator (_XList* l)
: _XListIterator (l)
{
  if (id == _XSListID)
  {
    node = ((_XSList*)l)->first;
  }
  else
  {
    node = 0;
  }
}

_XSListIterator::_XSListIterator (_XList& l)
: _XListIterator (l)
{
  if (id == _XSListID)
  {
    node = ((_XSList*)&l)->first;
  }
  else
  {
    node = 0;
  }
}

void*
_XSListIterator::operator () ()
{
  if (id == _XSListID)
  {
    if (node == ((_XSList*)l)->sentinel)
    {
      return 0;
    }
    else
    {
      void* ret = node->GetItem ();
      node = node->GetNext ();
      return ret;
    }
  }
  else
  {
    // Ώۂ _XSList łȂ
    return _XListIterator::operator () ();
  }
}

void
_XSListIterator::Revert ()
{
  if (id == _XSListID)
  {
    node = ((_XSList*)l)->sentinel;
  }
  else
  {
    // Ώۂ _XSList łȂ
    _XListIterator::Revert ();
  }
}
