// -------------------------------------------------------------------- //
// wnd.cpp:
//
// class Wnd
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/1/lw/sample/wnd/RCS/wnd.cpp,v 1.6 1994/05/08 07:40:37 kudou Exp $

#include <windows.h>
#include "mswin.h"
#include "wnd.h"

static char* win_class_name = "Wnd";
bool Wnd::register_flag = False;

bool
Wnd::RegisteredP ()
{
  return MSWin::GetPrevInstance () || RegisterFlag ();
}

bool
Wnd::RegisterFlag ()
{
  return register_flag;
}

void 
Wnd::RegisterClass ()
{
  if (RegisteredP ())
  {
    return;
  }
  WNDCLASS wcClass;
  wcClass.lpszClassName = win_class_name;
  wcClass.hInstance     = MSWin::GetInstance ();
  wcClass.lpfnWndProc   = ::WindowProc;
  wcClass.hCursor       = LoadCursor (NULL, IDC_ARROW);
  wcClass.hIcon         = LoadIcon (MSWin::GetInstance (), IDI_APPLICATION);
  wcClass.lpszMenuName  = (LPSTR) NULL;
  wcClass.hbrBackground = GetStockObject (WHITE_BRUSH);
  wcClass.style         = CS_HREDRAW | CS_VREDRAW;
  wcClass.cbClsExtra    = 0;
  wcClass.cbWndExtra    = sizeof (Wnd*);
  ::RegisterClass (&wcClass);
  register_flag = True;
}

Wnd::Wnd ()
{
}

Wnd::~Wnd ()
{
}

void 
Wnd::OpenWindow ()
{
  RegisterClass ();
  SetHandle (::CreateWindow (win_class_name,	// window class name
			     win_class_name,	// window title.
			     (WS_OVERLAPPEDWINDOW |
			      WS_MAXIMIZEBOX |
			      WS_MINIMIZEBOX),	// type of window
			     CW_USEDEFAULT,	// x - default location.
			     0,
			     CW_USEDEFAULT,	// y - default location.
			     0,
			     NULL,		// no parent window
			     NULL,		// use the class menu
			     MSWin::GetInstance (),// who created this window
			     (LPSTR) this));	// params to pass on
  Update ();
}

void
Wnd::Update ()
{
  ::ShowWindow (GetHandle (), MSWin::GetCmdShow ());// display this window
  ::UpdateWindow (GetHandle ());		// paint the clinent area.
}

long 
Wnd::WindowProc (UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
   case WM_DESTROY:
    ::PostQuitMessage (0);
    break;
    
   default:
    return ::DefWindowProc (handle, msg, wparam, lparam);
  }
  return 0L;
}

CFUNC long CALLBACK 
WindowProc (HWND handle, UINT msg, WPARAM wparam, LPARAM lparam)
{
#if defined (__SMALL__) || defined (__MEDIUM__)
  Wnd* wd = (Wnd*)::GetWindowWord (handle, 0);
#endif
#if defined (__LARGE__) || defined (__COMPACT__)
  Wnd* wd = (Wnd*)::GetWindowLong (handle, 0);
#endif
  if (wd == 0)
  {
    if (msg == WM_CREATE)
    {
      LPCREATESTRUCT lpcs;
      lpcs = (LPCREATESTRUCT)lparam;
      wd = (Wnd*)lpcs->lpCreateParams;
#if defined (__SMALL__) || defined (__MEDIUM__)
      ::SetWindowWord (handle, 0, (WORD)wd);	// regist this to window
#endif
#if defined (__LARGE__) || defined (__COMPACT__)
      ::SetWindowLong (handle, 0, (LONG)wd);	// regist this to window
#endif
    }
    else
    {
      return ::DefWindowProc (handle, msg, wparam, lparam);
    }
  }
  return wd->WindowProc (msg, wparam, lparam);
}

HDC 
Wnd::GetDC ()
{
  return ::GetDC (GetHandle ());
}

void 
Wnd::ReleaseDC (HDC dc)
{
  ::ReleaseDC (GetHandle (), dc);
}

// class Paint
Paint::Paint (HWND h)
{
  Paint::h = h;
  dc = ::BeginPaint (h, &ps);
}

Paint::~Paint ()
{
  ::EndPaint (h, &ps);
}
