// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// basewnd.h:
//
// class BaseWnd
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/basewnd.h,v 1.8 1994/05/04 17:34:20 kudou Exp $

#ifndef _lw_basewnd_h
#define _lw_basewnd_h

class BaseWnd
: public Wnd
{
  static bool register_flag;

 protected:
  virtual void InitMenu (HMENU h_menu);
  virtual bool RegisterFlag ();
  virtual void SetRegisterFlag ();
  virtual void RegisterClass ();
  virtual LPSTR GetClassName ();
  virtual WNDPROC GetWindowProc ();
  virtual UINT GetStyle ();
  virtual HANDLE GetCursor ();
  virtual HANDLE GetIcon ();
  virtual LPSTR GetMenuName ();
  virtual LPSTR GetCaptionStr ();
  virtual DWORD GetCreateWindowStyle ();
  virtual int GetCreateWindowXPos ();
  virtual int GetCreateWindowYPos ();
  virtual int GetCreateWindowXSize ();
  virtual int GetCreateWindowYSize ();
  virtual HWND GetParent ();
  virtual void OpenChildWindow ();
  virtual long WindowProc (UINT msg, WPARAM wparam, LPARAM lparam);
  virtual void Display (Paint& pnt);
  virtual void Display (HDC dc);
  virtual uword Menu (WPARAM wparam, LPARAM lparam);
  virtual uword Exit (bool menu_state);
  virtual uword About (bool menu_state);
  
 public:
  BaseWnd ();
  ~BaseWnd ();
  void OpenWindow ();
  void DisplayGrayFrame (HDC dc, int border_size);
};

#endif /* _lw_basewnd_h */
