// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// toolbar.h:
//
// class ToolBarWnd
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/toolbar.h,v 1.2 1994/04/24 05:25:42 kudou Exp $

#ifndef _lw_toolbar_h
#define _lw_toolbar_h

class ToolBarButtonEntry
{
  char* bitmap_name;
  int menu_id;
  ToolBarButtonEntry* next;
  
 public:
  ToolBarButtonEntry (char* bitmap_name,
		      int menu_id,
		      ToolBarButtonEntry* next)
  {
    ToolBarButtonEntry::bitmap_name = bitmap_name;
    ToolBarButtonEntry::menu_id = menu_id;
    ToolBarButtonEntry::next = next;
  }
  char* GetBitmapName () { return bitmap_name; }
  int GetMenuId () { return menu_id; }
  ToolBarButtonEntry* GetNext () { return next; }
};

enum ToolButtonSize
{
  SmallBtn = 20,
  MiddleBtn = 24,
  LargeBtn = 34,
};

class ToolBarWnd
: public BaseWnd
{
  static bool register_flag;
  Wnd* parent;
  ToolBarButtonEntry* entrys; 
  ToolButtonSize button_size;
  int pushed_button;
  
 protected:
  virtual bool RegisterFlag ();
  virtual void SetRegisterFlag ();
  virtual LPSTR GetClassName ();
  virtual DWORD GetCreateWindowStyle ();
  virtual HWND GetParent ();
  virtual long WindowProc (UINT msg, WPARAM wParam, LPARAM lParam);
  virtual void Display (HDC hdc);

 public:
  ToolBarWnd (Wnd* parent);
  ~ToolBarWnd ();
  Wnd* GetParentWnd () { return parent; }
  void AddButton (char* bitmap_name, int menu_id);
  int GetToolBarHeight () { return button_size + 2; }
  ToolButtonSize GetToolButtonSize () { return button_size; }
  void SetToolButtonSize (ToolButtonSize size) { button_size = size; }
  
 private:
  int GetEntryNum ();
  int MouseMoveX (UINT x, UINT y);
  void MouseMove (UINT x, UINT y);
  void MouseButtonUp (UINT x, UINT y);
  void MouseButtonDown (UINT x, UINT y);
  int WhatButton (UINT x, UINT y);
  ToolBarButtonEntry* GetNEntry (int n);
  void InvalidateButton (int n);
};

struct ButtonMenuId
{
  char* bttn_name;
  int menu_id;
 public:
  static int GetMenuId (ButtonMenuId* button_menu_id, char* bttn_name);
};

#endif /* _lw_toolbar_h */
