// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// main.cc:
//
// main
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/main.cc,v 1.12 1994/05/06 01:37:28 kudou Exp $

#include "wool.h"

#ifdef MSW
//
// for Microsoft Windows
// with Leaf for Windows class library
//
#include "lw.h"
#include <stdarg.h>
#include "flow.h"

#ifdef MSWG
#include "wingrph.h"
#endif

class WOFlow
: public OFlow
{
  TextWnd& text_wnd;
  
 public:
  WOFlow (TextWnd& w) : text_wnd(w) { ; }
  ~WOFlow () { ; }
  bool ErrorP () { return False; }
  void Printf (char* f, ...)
  {
    va_list ap;
    va_start (ap, f);
    text_wnd.Vprintf (f, ap);
    va_end (ap);
  }
  void Vprintf (char* f, va_list arg)
  {
    text_wnd.Vprintf (f, arg);
  }
};

class WIFlow
: public IFlow
{
  TextWnd& text_wnd;
  
 public:
  WIFlow (TextWnd& w) : text_wnd(w) { ; }
  ~WIFlow () { ; }
  bool ErrorP () { return False; }
  char* Gets (char* read_buf, size_t read_buf_size)
  {
    return text_wnd.Gets (read_buf, read_buf_size);
  }
};

class ConsoleWnd
: public TextWnd
{
 public:
  virtual LPSTR GetCaptionStr ()
  {
    return "WOOL Console";
  }  
};

int
Main ()
{
  ConsoleWnd wnd;
  wnd.OpenWindow ();
  wnd.SetCookedMode ();
#ifdef MSWG
  GrphWnd::OpenGrphWnd ();
#endif
  WIFlow* i_flow = new WIFlow (wnd);
  WOFlow* o_flow = new WOFlow (wnd);
  Wool* wool = ::new Wool (i_flow, o_flow, o_flow);
  wool->Run ();
  delete wool;
  delete o_flow;
  delete i_flow;
#ifdef MSWG
  GrphWnd::CloseGrphWnd ();
#endif
  return 0;
}

#else /* MSW */
//
// for STDIO
//
#include "file.h"
extern "C"
{
#include <stdio.h>
}

void
WoolStart (IFile* i_file, OFile* o_file, OFile* err_file)
{
  Wool* wool = ::new Wool (i_file, o_file, err_file);
  wool->Run ();
  delete wool;
}

int
main (int /*argc*/, char** /*argv*/)
{
  IFile* i_file = new IFile (stdin);
  OFile* o_file = new OFile (stdout);
  OFile* err_file = new OFile (stderr);
  WoolStart (i_file, o_file, err_file);
  delete err_file;
  delete o_file;
  delete i_file;
  return 0;
}
#endif /* MSW */
